#!/bin/sh

confile=$1
MAIL='/usr/bin/mail'
OS=`uname`
if [ "${OS}" = "FreeBSD" ]; then
ps="ps -ax -w"
sed="sed -E"
else
ps="ps -e -o pid,state,command"
sed="sed -r"
fi
SNfile=`ls / |grep -E "SN[0-9]{8}"`
ip=`sed -n  '2p' /$SNfile|awk -F'[:+ ]' '{print $3}'`
procmon () {
	_PNAME=$1
	_PDD=$2
	_PCOM=$3
	if [ "${_PNAME}" = "pid" ]; then
		procname=`echo ${_PDD} | $sed 's/(.*\/|\.pid)//g'`
		if [ -r ${_PDD} ]; then
			pid=`cat ${_PDD}`
			ps $pid 2>&1 > /dev/null	
			if [ $? -ne 0 ]; then
				procid=
			else
				procid=$pid
			fi
		else
			procid=	
		fi
	else
		procname=${_PNAME}
		if [ "${_PDD}" = "no" ]; then
			procid=`$ps | grep ${_PNAME} | grep -v grep | awk '{print $1}'`	
		else
			procid=`$ps | grep ${_PNAME} | grep ${_PDD} | \
			grep -v grep | awk '{print $1}'` 
		fi
	fi
	#echo $procname
	#echo "${_PNAME}:${_PDD}"
	#echo "procid:$procid"
	if [ -z "$procid" ]; then
		${_PCOM} start > /tmp/procmon.tmp 2>&1
		printf "`date`\n`cat /tmp/procmon.tmp`\n$procname is restart" >> /tmp/procmon.log
		
	fi
}

while read LINE; do
proc=`echo ${LINE} | cut -f 1 -d '#'`
if [ -n "${proc}" ]; then
procmon $proc
fi
done < ${confile} 

